﻿//=============================================================================
//
//          Copyright (c) 2022 Beijing Dreamagic Science and Technology Co.,Ltd.
//                          All Rights Reserved.
//
//=============================================================================
using Qiyi.UI.InputField;
using System.Collections.Generic;
using Unity.XR.Qiyu;
using UnityEngine;
using UnityEngine.UI;

public class MainTest : MonoBehaviour
{
    public Text refreshRateText;

    List<float> refreshRateList = new List<float>();
    int refreshRateIndex = 0;
    int trackingMode = 0;

    void Start()
    {
        float[] refreshRates;
        if (QiyuXRCore.TryGetAvailableDisplayRefreshRates(out refreshRates))
        {
            refreshRateList = new List<float>(refreshRates);
            Debug.Log("TryGetAvailableDisplayRefreshRates:" + string.Join(",", refreshRateList));
        }

        float refreshRate;
        if (QiyuXRCore.TryGetDisplayRefreshRate(out refreshRate))
        {
            refreshRateText.text = $"RefreshRate({refreshRate})";
            refreshRateIndex = refreshRateList.IndexOf(refreshRate);
            Debug.Log("TryGetDisplayRefreshRate:" + refreshRate);
        }

        var deviceInfo = QiyuXRCore.GetDeviceInfo();
        Debug.LogFormat("GetDeviceInfo->Manufacturer:{0},Name_HMD:{1},SN_HMD:{2},Name_CtrL:{3},Name_CtrR:{4}", deviceInfo.Manufacturer, deviceInfo.Name_HMD, deviceInfo.SN_HMD, deviceInfo.Name_CtrL, deviceInfo.Name_CtrR);
    }

    public void OnApplicationPause(bool pause)
    {

    }

    public void OnButtonClick(GameObject btn)
    {
        if (btn.name == "TrackingMode")
        {
            if (trackingMode == 0)
            {
                trackingMode = 1;
                QiyuXRCore.SetAppTrackingMode(trackingMode);
                btn.GetComponentInChildren<Text>().text = $"3Dof(On)";
            }
            else
            {
                trackingMode = 0;
                QiyuXRCore.SetAppTrackingMode(trackingMode);
                btn.GetComponentInChildren<Text>().text = $"3Dof(Off)";
            }
        }
        else if (btn.name == "RefreshRate")
        {
            if (++refreshRateIndex >= refreshRateList.Count)
                refreshRateIndex = 0;

            float refreshRate = refreshRateList[refreshRateIndex];

            if (QiyuXRCore.TrySetDisplayRefreshRate(refreshRate))
            {
                Debug.Log("TrySetDisplayRefreshRate:" + refreshRate);
                refreshRateText.text = $"RefreshRate({refreshRate})";
            }
            else
            {
                Debug.Log("TrySetDisplayRefreshRate Error!");
            }
        }
    }
}
